---
title: Book Markdown Template
subtitle: Scientific Markdown Syntax
author: Culture Academy
abstract: This template explains writing scientific publications in markdown and provides code example. Footnotes, citations, tables, figures etc. are possible.
keywords: ['tutorial','science']

# README

# uncomment, delete or alter yaml options below to set template
# usage of citation explained in body
# if you don't need ebook publication for example, just remove the block

# fontfamily: noto | nunito | cabin | AlegreyaSans | Archivo | lxfonts | libertinus | helvet | actualarialangle
# or set `header-includes` to
#    - \usepackage{fontspec}
#    - \setmainfont{Source Code Pro}

# suppress page numbers with:
#    - \pagenumbering{gobble}

lof: true         # list of figures
lot: true         # list of tables

toc: true                      # table of contents
toc-depth: 2                   # list to which heading level
top-level-division: chapter    # don't make use of parts

fontsize: 10pt
fontfamily: noto 
numbersections : true
linestretch: 1.0

geometry:
    - top=25mm
    - bottom=25mm
    - left=25mm
    - right=35mm
    - heightrounded

classoption:
    - titlepage   # print separate title page
    - twoside     # two-sited printing,  alternate
    # - twocolumn # two column printing,  alternate
    # - landscape # landscape orientation, portrait is default
    # - openright # chapters start on the right side,  default

bibliography:
    - bibliography.bib
biblio-style: "authoryear-comp"
abbreviations: abbreviations.md

pdf-engine: xelatex
citeproc: true
from: markdown+tex_math_single_backslash+tex_math_dollars+raw_tex
to: pdf

documentclass: article
template: default

epub-cover-image: cover.jpg
epub-title-page: false
epub-metadata: meta.xml

lang: "en"
biblio-title: "Bibliography"
toc-title: "Table of Contents"

hyperrefoptions:
    - linktoc=all
    - pdfwindowui
    - pdfpagemode=FullScreen
urlcolor: "blue"
link-citations: true

header-includes:
    - \usepackage[utf8]{inputenc}
---

# Converting to .pdf
- use `pandoc` with `--citeproc` option, this handles the citations
- most of other options can be set here in place in the yaml frontmatter
- the following bash script handles it nicely

## bash script
```
#!/bin/bash
mkdir $(BUILDDIR) -p  # Creates the BUILDDIR if it doesn't already exist.
pandoc $(FILENAME).md \
--citeproc \
--output=$(BUILDDIR)/$(FILENAME).pdf \
--pdf-engine=xelatex
```
# General Markdown conventions
- `_single underscores_` produce _italic_ text
- `_double underscores_` produce __bold__ text
- `*italic*` and `**bold**` analogous with `*`
- `[desciption](url)`   links with pretty name are rendered like [Culture Academy](https://culture-academy.org)
- alternatively just link `(https://culture-academy.org)` undered like (https://culture-academy.org)

# Headings
Headings are ordered by the number of `#` at the beginning. There are other options, but they don't fold that well in editors.
```
# h1 Heading
## h2 Heading
### h3 Heading
#### h4 Heading
##### h5 Heading
###### h6 Heading
```
# Multiple Lines
By default, `pandoc`, respectively \LaTeX{} binds lines separated by only one new line together. This can be circumvented by:
1. adding to spaces at the end of the line
2. adding a `\` at the end of the line

This is a line with one space.
This line has two spaces.  
This line has a backslash.\
And this lonely little line is the end of it.

# Lists
## Unordered lists
- unordered list items
- are done by 
    - adding a `-`, `+`, or `*`
    - with followig space at the beginning of a line
- there can be multiple levels
    - going deep
        - and deeper

## Ordered lists
1. ordered lists are done by either
    1. adding `1.`, `2.` and so forth at the beginning of lines or
    2. just any numbers like `1.`, `1.` and counting
2. meaning that the numeration is done automatically either way
3. there can also be multiple levels
    1. also
    1. numbering
        1. automatically
        1. with either method
    1. just fine
4. sometimes it helps to **add new lines in between**

# Blockquotes

> Blockquotes are done 
> by `>` at the beginning of lines
> they cannot be nested, when I tested with `pandoc` to `.pdf`

# Images and figures
- `![image with caption](cultureacademy.png)` sets a figure with caption, added to `lof`

![image with caption](cultureacademy.png)

- `![caption](cultureacademy.png) \` sets no caption, notice the `\` at the end

![image without caption](cultureacademy.png) \

# Tables

## Unlisted tables
```
| Option | Description |
| ------ | ----------- |
| data   | path to data files to supply the data that will be passed into templates. |
| engine | engine to be used for processing templates. Handlebars is the default. |
| ext    | extension to be used for dest files. |
```

| Option | Description |
| ------ | ----------- |
| data   | path to data files to supply the data that will be passed into templates. |
| engine | engine to be used for processing templates. Handlebars is the default. |
| ext    | extension to be used for dest files. |

## Listed tables

Listed tables are added to the List of Tables (`lof`)

```
| Option | Description |
| ------ | ----------- |
| data   | path to data files to supply the data that will be passed into templates. |
| engine | engine to be used for processing templates. Handlebars is the default. |
| ext    | extension to be used for dest files. |
Table: Caption for your table
```

| Option | Description |
| ------ | ----------- |
| data   | path to data files to supply the data that will be passed into templates. |
| engine | engine to be used for processing templates. Handlebars is the default. |
| ext    | extension to be used for dest files. |
Table: Table listed in List of Tables

## Tables with right aligned columns
```
| Option | Description |
| ------:| -----------:|
| data   | path to data files to supply the data that will be passed into templates. |
| engine | engine to be used for processing templates. Handlebars is the default. |
| ext    | extension to be used for dest files. |
```

| Option | Description |
| ------:| -----------:|
| data   | path to data files to supply the data that will be passed into templates. |
| engine | engine to be used for processing templates. Handlebars is the default. |
| ext    | extension to be used for dest files. |

# Horizontal Lines

Separating lines are done by.

- `---`
- `___`
- `***`

---

# [Definition lists](https://github.com/markdown-it/markdown-it-deflist)

## Definition list compact style

```
Term 1
  ~ Definition 1

Term 2
  ~ Definition 2a
  ~ Definition 2b
```

results in:

Term 1
  ~ Definition 1

Term 2
  ~ Definition 2a
  ~ Definition 2b

## Definition list with more meanings

### Definition with lazy continuation
```
Term 1

:   Definition 1
with lazy continuation.
```
results in

Term 1

:   Definition 1
with lazy continuation.

### Definition with multiple lines
```
Term 2 with *inline markup*

:   Definition 2

        { some code, part of Definition 2 }

    Third paragraph of definition 2.
```
results in 

Term 2 with *inline markup*

:   Definition 2

        { some code, part of Definition 2 }

    Third paragraph of definition 2.


# [Abbreviations](https://github.com/markdown-it/markdown-it-abbr)
Abbreviations are only supported via multimarkdown or other extensions. This means, installing `multimarkdown` from repo or else and converting from `markdown_mmd` instead. It's troublesome to make it work anyway. In this template, it **does not work**!

- define abbreviations file in frontmatter `abbreviations: abbreviations.md`
- install `multimarkdown`
- tell `pandoc` to convert from `markdown_mmd`
- set up `abbreviations.md` like:

```
# --- abrevations.md ---

[+MMA]: Mixed Martial Arts

# ---       end      ---
```

and use in text like: `[+MMA] is a fine art.` 

# Citiation
- `[@author1999, 132]` inserts citation, pagenumber is optional

»Lorem ipsum dolor sit amet, consectetur adipisici elit, sed eiusmod tempor incidunt ut labore et dolore magna aliqua.« [@author1999, 132]

## Inline citation of authors
- as `@ckw2025` stated …

As @ckw2025 stated: »Martial Arts \& Combat Sports sind psycho-physische Körpertechnologien und als solche historisch soziokulturell bestimmt.«

# Code snippets
- code like `fortune | cowsay` is enclosed in `
- code blocks are enclosed in fences, like below
- syntax higlighting can be achieved by adding the language name after the beginning of the block

````markdown
``` bash
#!/bin/bash
# example code block
ps -aux | grep bash
```
````
results in

```bash
#!/bin/bash
# example code block
ps -aux | grep bash
```

# Footnotes
## Footnote by placeholder
This is a text with footnote[^1].

[^1]: by _placeholder_.

## Footnote inline
A footnote can be done inline^[faster, but maybe a little messy in the text to maintain an overview.].

## File inclusion
- handled by `include-files.lua` plugin
- must be specified as command line parameter or in frontmatter
- handled best as fenced codeblock with `{.include}<file1><file2>`
``` {.include}
book-included.md
```

\newpage

# Bibliography
_The bibliography is added with the backmatter and needs a separate Headline apparently._

